/*
 * Decompiled with CFR 0.152.
 */
package com._idrae.travelers_index.network;

import com._idrae.travelers_index.client.gui.IndexScreen;
import com._idrae.travelers_index.data.ItemChecklist;
import java.util.function.Supplier;
import net.minecraft.item.Item;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;

public class SendCheckListToClientPacket {
    private ItemChecklist checklist;

    public SendCheckListToClientPacket(PacketBuffer buffer) {
        this.checklist = new ItemChecklist();
        this.checklist.init();
        while (buffer.isReadable()) {
            int i1 = buffer.func_150792_a();
            int i2 = buffer.readInt();
            this.checklist.getChecklist().put(Item.func_150899_d((int)i1), i2);
        }
    }

    public SendCheckListToClientPacket(ItemChecklist checklist) {
        this.checklist = checklist;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemChecklist getCheckList() {
        return this.checklist;
    }

    public void encode(PacketBuffer buffer) {
        for (Item item : this.checklist.getChecklist().keySet()) {
            buffer.func_150787_b(Item.func_150891_b((Item)item));
            buffer.writeInt(this.checklist.getChecklist().get(item).intValue());
        }
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> this::handleOnClient));
        context.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void handleOnClient() {
        IndexScreen.checklist = this.getCheckList();
    }
}

